
## Packages

library(tidyverse)
library(readxl)
library(openxlsx)
library(here)
library(ggplot2)
library(countrycode)
library(lubridate)
library(scales)
library(dplyr)


## Data inputs
data_path <- "raw data"

#trade data
path_to_IM <- file.path(data_path, "import data_hs08_aug.xlsx")
path_to_countryim <-file.path(data_path, "cifval_25_bycountry.xlsx")
path_to_countrycald <-file.path(data_path, "cald_25_bycountry.xlsx")

#hs codes for 
list1 <- file.path(data_path, "new examption list 1.txt")
list2<- file.path(data_path, "list 2 ex religious purposes only.txt")

## Path to save outputs
path_to_output <- here("output")

## Run the codes in the following order
source("code/01-processing.R")
source("code/02-constructing figure1 data.R")
source("code/03-constructing figure2 data.R")
source("code/04-product level data.R")
source("code/05-exporting data.R")


